% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Preselection.R
\name{Preselection}
\alias{Preselection}
\title{Selection of an initial spread set}
\usage{
Preselection(pik, coord, L = 1, EPS = 1e-09)
}
\arguments{
\item{pik}{a matrix of temporal inclusion probabilities.
Columns of \code{pik} correspond to the times, and rows correspond to the units.
Inclusion probabilities can be totally unequal.}

\item{coord}{a matrix that contains spatial coordinates in columns. The number of columns can be more than two.
Matrix rows correspond to the units.}

\item{L}{a parameter to achieve good spatial balanced (see details). Default value is 1.}

\item{EPS}{a tolerance parameter. Default value is 1e-9.}
}
\value{
a matrix with the same size as \code{pik} that contains new temporal inclusion probabilities.
Some inclusion probabilities are updated to 0.
}
\description{
Select an initial spread set using the flight phase of the local cube method. Some inclusion probabilities are set to 0.
The others probabilities are also modified so as not to change the sum of the inclusion probabilities.
}
\details{
\code{L} is used to achieve good spatial balance. It must be equal to or larger than one.
}
\examples{
## Coordinates in two dimensions of 4 units ##
coord <- matrix(c(0.5,0.6,0.2,0.3,0.8,0.9,0.4,0.7), ncol=2)
## Temporal inclusion probabilities with 3 waves and 4 units ##
pik <- matrix(c(0.6,0.3,0.3,
                0.2,0.4,0.9,
                0.3,0.2,0.5,
                0.9,0.1,0.3), ncol = 3, byrow = TRUE)
## Selection of an initial spread set ##
Preselection(pik, coord)

}
\references{
Grafstrom, A., Lundstrom, N. L. P., and Schelin, L. (2012). Spatially balanced sampling through the pivotal method. Biometrics, 68(2):514-520.
}
\seealso{
\code{\link[sampling:fastflightcube]{fastflightcube}}
}
\author{
Esther Eustache \email{esther.eustache@unine.ch}
}
