% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/outliers.R
\name{outliers}
\alias{outliers}
\title{Identify outliers in a variable}
\usage{
outliers(vector)
}
\arguments{
\item{vector}{an integer or numeric vector}
}
\value{
a list with two elements: count and index of outliers
}
\description{
Takes in a vector, and returns count and index of outliers
}
\details{
The function uses the same criteria to identify outliers as the one used for
 box plots. All values that are greater than 75th percentile value + 1.5 times the
 inter quartile range or lesser than 25th percentile value - 1.5 times the inter
 quartile range, are tagged as outliers.

 The individual elements (number of outliers and index of outliers) of the two
 element output list can be picked using the code given in example. The index
 of outliers can be used to get a vector of all outliers.
}
\examples{
# Scores vector
scores <- c(1, 4, 7, 10, 566, 21, 25, 27, 32, 35,
            49, 60, 75, 23, 45, 86, 26, 38, 34, 223, -3)

# Identify the count of outliers and their index
ltOutliers <- outliers(vector = scores)
numOutliers <- ltOutliers$numOutliers
idxOutliers <- ltOutliers$idxOutliers
valOutliers <- scores[idxOutliers]
}
\author{
Akash Jain
}
\seealso{
\code{\link{decile}}, \code{\link{pentile}}, \code{\link{imputemiss}}
}

