% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovarianceM.R
\name{CovarianceM}
\alias{CovarianceM}
\title{Covariance matrix for spatio-temporal model}
\usage{
CovarianceM(phi, rho, tau2, sigma2, distSpa, disTemp, kappa, type.S)
}
\arguments{
\item{phi}{value of the spatial scaling parameter.}

\item{rho}{value of the time scaling parameter.}

\item{tau2}{value of the the nugget effect parameter.}

\item{sigma2}{value of the the model variance.}

\item{distSpa}{Spatial distance matrix without considering repetitions.}

\item{disTemp}{Temporal distance matrix without considering repetitions.}

\item{kappa}{parameter for all spatial covariance functions. In the case of exponential, gaussian and spherical function \eqn{\kappa} is equal to zero.}

\item{type.S}{type of spatial covariance function: '\code{exponential}' for exponential, '\code{gaussian}' for gaussian,
'\code{matern}' for matern, '\code{pow.exp}' for power exponential and '\code{spherical}' for spherical function, respectively.
Default is \code{exponential} function.}
}
\value{
The function returns the spatio-temporal covariance matrix.
}
\description{
It computes the spatio-temporal covariance matrix. For the spatial function we have 5 differents correlation matrix:
exponential, gaussian, matern, spherical and power exponential correlation matrix; and for the temporal function is
a correlation matrix of an autorregressive model AR(1).
}
\examples{
# Initial parameter values
beta <- c(-1,1.50); phi <- 5; rho <- 0.45; tau2 <- 0.80; sigma2 <- 2
# Simulating data
n1 <- 10   # Number of spatial locations
n2 <- 5    # Number of temporal index
set.seed(1000)
x.coord <- round(runif(n1,0,10),9)    # X coordinate
y.coord <- round(runif(n1,0,10),9)    # Y coordinate
coordenadas <- cbind(x.coord,y.coord) # Cartesian coordinates without repetitions
time <- as.matrix(seq(1,n2,1))        # Time index without repetitions
# Covariance matrix
H <- as.matrix(dist(coordenadas)) # Spatial distances
Mt <- as.matrix(dist(time))       # Temporal distances
Cov <- CovarianceM(phi,rho,tau2,sigma2,distSpa=H,disTemp=Mt,kappa=0,type.S="exponential")
}
\author{
Katherine A. L. Valeriano, Victor H. Lachos and Larissa A. Matos
}
