% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ornstein_uhlenbeck.R
\name{ornstein_uhlenbeck}
\alias{ornstein_uhlenbeck}
\title{simulate ornstein-uhlenbeck (OU) process}
\usage{
ornstein_uhlenbeck(t, mu = 0, theta = 1, sigma = 1, y0 = 0)
}
\arguments{
\item{t}{times at which the process is simulated. Can be heterodistant}

\item{mu}{number, long term mean}

\item{theta}{number, mean reversion speed}

\item{sigma}{positive number, strength of randomness}

\item{y0}{number, initial value (value of process at the first entry of t)}
}
\value{
A list with two elements: \code{t} and \code{y}. \code{t} is a duplicate of the input \code{t}, \code{y} are the values of the OU process at these times. Output list is of S3 class \code{timelist} (inherits from \code{list}) and can thus be plotted directly using \code{plot}, see \code{?admtools::plot.timelist}
}
\description{
Simulates an Ornstein-Uhlenbeck process using the Euler-Maruyama method. The process is simulated on a scale of \code{0.25 * min(diff(t))} and then interpolated to the values of \code{t}.
}
\examples{

library("admtools") # required for plotting of results
t = seq(0, 3, by = 0.01)
l = ornstein_uhlenbeck(t, y0 = 3) # start away from optimum (mu)
plot(l, type = "l")
l2 = ornstein_uhlenbeck(t, y0 = 0) # start in optimum
lines(l2$t, l2$y, col = "red")


}
\seealso{
\itemize{
\item \code{\link[=ornstein_uhlenbeck_sl]{ornstein_uhlenbeck_sl()}} for simulation on specimen level - for use in conjunction with \code{paleoTS} package
\item \code{\link[=random_walk]{random_walk()}} and \code{\link[=stasis]{stasis()}} to simulate other modes of evolution
}
}
