% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_train.R
\name{predict.submod_train}
\alias{predict.submod_train}
\title{Subgroup Identification: Train Model (Predictions)}
\usage{
\method{predict}{submod_train}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained submod model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Identified subgroups with subgroup-specific predictions (depends on subgroup
model)
\itemize{
  \item Subgrps - Identified subgroups
  \item pred - Predictions, depends on subgroup model
}
}
\description{
Prediction function for the trained subgroup identification model (submod).
}
\examples{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Fit through submod_train wrapper #
mod1 = submod_train(Y=Y, A=A, X=X, Xtest=X, submod="submod_lmtree")
out1 = predict(mod1)
table(mod1$Subgrps.train)
table(out1$Subgrps)

}
