% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balstrat.R
\name{balstrat}
\alias{balstrat}
\title{Balanced Stratification}
\usage{
balstrat(X, strata, pik)
}
\arguments{
\item{X}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{strata}{A vector of integers that specifies the stratification.}

\item{pik}{A vector of inclusion probabilities.}
}
\value{
A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
}
\description{
Select a stratified balanced sample. The function is similar to \code{\link[sampling:balancedstratification]{balancedstratification}} of the package sampling.
}
\details{
The function implements the method proposed by Chauvet (2009). Firstly, a flight phase is performed on each strata. Secondly, a flight phase is applied on the whole population by aggregating the strata. Finally, a landing phase is applied by suppression of variables.
}
\examples{

N <- 100
n <- 10
p <- 4
X <- matrix(rgamma(N*p,4,25),ncol = p)
strata <- as.matrix(rep(1:n,each = N/n))
pik <- rep(n/N,N)

s <- balstrat(X,strata,pik)

t(X/pik)\%*\%s
t(X/pik)\%*\%pik

Xcat <- disj(strata)

t(Xcat)\%*\%s
t(Xcat)\%*\%pik
}
\references{
Chauvet, G. (2009). Stratified balanced sampling. \emph{Survey Methodology}, 35:115-119.
}
\seealso{
\code{\link{ffphase}},\code{\link{landingRM}}
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
