\name{StreamingLm}
\alias{StreamingLm}
\title{Streaming Regression with R}
\usage{
  StreamingLm(model, file, number_of_rows_per_update,
  column_classes, column_names)
}
\arguments{
  \item{model}{the linear model}

  \item{file}{the file connection. For example, a standard
  input connection or a file connection}

  \item{number_of_rows_per_update}{the number or rows to
  read before running an update to the solution}

  \item{column_classes}{the class types for each column of
  the comma-separated-value rows read from the connection}

  \item{column_names}{the names of the columns to read. For
  example, one or more of the variables in the model.}
}
\description{
  Reads rows od CSV-valued data from standard in and runs
  repeated updates to the solution of a linear model.
}
\details{
  Intended to be used for very large scale data analysis
  using standard-in streaming.

  Utilizes biglm's update function to update a solution
  based on chunked rows of CSV input data.

  Running the Example: ./example.sh
}
\examples{
require(StreamingLm)
con <- pipe(description="echo '1,2\\n2,4'") # y = 0 + 0.5 * x1
open(con)
solution <- StreamingLm(model=y~x1, file=con, number_of_rows_per_update=2, column_classes=rep('integer',2),column_names=c('y','x1'))
coef(solution) # y = 0 + 0.5 * x1
}

