% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.train}
\alias{prim.train}
\title{The main PRIM function}
\usage{
prim.train(data, yvar, censorvar, trtvar, trtref = NULL, xvars, type, des.res,
  alpha = c(0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.2, 0.3, 0.4, 0.5),
  min.sigp.prcnt = 0.2, training.percent = 0.5, n.boot = 0,
  pre.filter = NULL, filter.method = NULL)
}
\arguments{
\item{data}{the input data frame}

\item{yvar}{name for response variable}

\item{censorvar}{name for censoring (1: event; 0: censor), default = NULL}

\item{trtvar}{name for treatment variable, default = NULL (prognostic signature)}

\item{trtref}{coding (in the column of trtvar) for treatment arm}

\item{xvars}{vector of variable names for predictors (covariates)}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response}

\item{alpha}{a parameter controlling the number of patients in consideration}

\item{min.sigp.prcnt}{desired proportion of signature positive group size for a given cutoff.}

\item{training.percent}{percentage of subjects in the initial training data}

\item{n.boot}{number of bootstrap for the variable selection procedure for PRIM}

\item{pre.filter}{NULL, no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected}

\item{filter.method}{NULL, no prefiltering, "univariate", univaraite filtering; "glmnet", glmnet filtering, "unicart": univariate rpart filtering for prognostic case}
}
\value{
the final list of rules selected by PRIM.
}
\description{
The main PRIM function
}
