% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sra.R
\name{test_sra}
\alias{test_sra}
\title{Compute a Kolmogorov-Smirnoff-like test for Smooth quantiles of a matrix of sequential rank agreements}
\usage{
test_sra(object, nullobject, weights = 1)
}
\arguments{
\item{object}{An object created with \code{sra}.}

\item{nullobject}{An object created with \code{random_list_sra}.}

\item{weights}{Either a single value or a vector of the same length as the number of item with the weight that should be given to specific depths.}
}
\value{
A single value corresponding to the p-value
}
\description{
Compute a Kolmogorov-Smirnoff-like test for Smooth quantiles of a matrix of sequential rank agreements
}
\examples{
# setting with 3 lists
mlist <- matrix(cbind(1:8,c(1,2,3,5,6,7,4,8),c(1,5,3,4,2,8,7,6)),ncol=3)
# compute sequential rank agreements
x=sra(mlist)
# compute rank agreement of 5 random permutations
null=random_list_sra(mlist,n=15)
# now extract point-wise quantiles according to confidence level
test_sra(x,null)
# compare to when we use the result of the first permutation run
test_sra(null[,1],null[,-1])

}
\author{
Claus Ekstrøm <ekstrom@sund.ku.dk>
}

