% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITCI-Dvine-inference-utils.R
\name{Dvine_ICA_confint}
\alias{Dvine_ICA_confint}
\title{Confidence interval for the ICA given the unidentifiable parameters}
\usage{
Dvine_ICA_confint(
  fitted_model,
  alpha,
  copula_par_unid,
  copula_family2,
  rotation_par_unid,
  n_prec,
  mutinfo_estimator = NULL,
  composite,
  B,
  seed
)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
contains the estimated identifiable part of the joint distribution for the
potential outcomes.}

\item{alpha}{(numeric) \code{1 - alpha} is the level of the confidence interval}

\item{copula_par_unid}{Parameter vector for the sequence of \emph{unidentifiable}
bivariate copulas that define the D-vine copula. The elements of
\code{copula_par} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}. The elements of
\code{copula_family2} correspond to \eqn{(c_{23}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par_unid}{Vector of rotation parameters for the sequence of
\emph{unidentifiable} bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{23}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{n_prec}{Number of Monte Carlo samples for the computation of the mutual
information.}

\item{mutinfo_estimator}{Function that estimates the mutual information
between the first two arguments which are numeric vectors. Defaults to
\code{FNN::mutinfo()} with default arguments.
@param plot_deltas (logical) Plot the sampled individual treatment effects?}

\item{composite}{(boolean)  If \code{composite} is \code{TRUE}, then the surrogate
endpoint is a composite of both a "pure" surrogate endpoint and the true
endpoint, e.g., progression-free survival is the minimum of time-to-progression
and time-to-death.}

\item{B}{Number of bootstrap replications}

\item{seed}{Seed for Monte Carlo sampling. This seed does not affect the global
environment.}
}
\value{
(numeric) Vector with the limits of the two-sided \code{1 - alpha}
confidence interval.
}
\description{
\code{\link[=Dvine_ICA_confint]{Dvine_ICA_confint()}} computes the confidence interval for the ICA
in the D-vine copula model. The unidentifiable parameters are fixed at the user
supplied values.
}
