% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvSurv.R
\name{plot.MetaAnalyticSurvSurv}
\alias{plot.MetaAnalyticSurvSurv}
\title{Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvSurv()' function.}
\usage{
\method{plot}{MetaAnalyticSurvSurv}(x, ...)
}
\arguments{
\item{x}{An object of class 'MetaAnalyticSurvSurv' fitted with the 'MetaAnalyticSurvSurv()' function.}

\item{...}{...}
}
\value{
A plot of the type ggplot
}
\description{
Generates a plot of the estimated treatment effects for the surrogate endpoint versus the estimated treatment effects for the true endpoint for an object fitted with the 'MetaAnalyticSurvSurv()' function.
}
\examples{
\dontrun{
data("colorectal4")
fit <- MetaAnalyticSurvSurv(data=Ovarian,true=Surv,trueind=SurvInd,surrog=Pfs,surrogind=PfsInd,
                            trt=Treat,center=Center,trial=Center,patientid=Patient,
                            copula="Plackett",adjustment="unadjusted")
plot(fit)
}

}
