% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RedWine}
\alias{RedWine}
\title{Red wine quality dataset of the Portuguese "Vinho Verde" wine}
\format{
A data frame with 1599 rows, quality score, and 11 variables of physicochemical properties of wines.
\itemize{
\item \code{quality} Tasting preference is a rating score provided by a minimum of three sensory with ordinal values from
0 (very bad) to 10 (excellent). The final sensory score is the median of these evaluations.

\item \code{fixed.acidity} The fixed acidity is the physicochemical property in unit (g(tartaric acid)/dm^3).
\item \code{volatile.acidity} The volatile acidity is in unit g(acetic acid)/dm^3.
\item \code{citric.acid} The citric acidity is in unit g/dm^3.
\item \code{residual.sugar} The residual sugar is in unit g/dm^3.
\item \code{chlorides} The chlorides is in unit g(sodium chloride)/dm^3.
\item \code{free.sulfur.dioxide} The free sulfur dioxide is in unit mg/dm^3.
\item \code{total.sulfur.dioxide} The total sulfur dioxide is in unit mg/dm^3.
\item \code{density} The density is in unit g/cm^3.
\item \code{pH} The wine's pH value.
\item \code{sulphates} The sulphates is in unit g(potassium sulphates)/dm^3.
\item \code{alcohol} The alcohol is in unit \\% vol.
}
}
\usage{
data(RedWine)
}
\description{
A red wine tasting preference data used in the study of Cortez, Cerdeira, Almeida, Matos,
and Reis 2009. This red wine contains 1599 samples and 12 variables including the tasting
preference score of red wine and its physicochemical characteristics.
}
\examples{
head(RedWine)
}
\references{
Cortez, P., Cerdeira, A., Almeida, F., Matos, T., and Reis, J. (2009), “Modeling wine
preferences by data mining from physicochemical properties,” Decision Support Systems,
47, 547–553. \doi{10.1016/j.dss.2009.05.016}
}
\keyword{datasets}
