% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General_tau.R
\name{General.tau}
\alias{General.tau}
\title{Information fractions under a generalized gamma survival distribution or a log-logistic survival distribution.}
\usage{
General.tau(t, R, T, FUN.C, q, mu, sigma, rho, eta, theta)
}
\arguments{
\item{t}{the interim analysis time (vector).}

\item{R}{the recuritment duration.}

\item{T}{the study duration.}

\item{FUN.C}{the cumulative distribution function of dropout censoring. \cr
FUN.C = function(y) punif(y,0,h) for a uniform dropout censoring U(0,h); \cr
FUN.C = function(y) rep(0,length(y)) for assuming no dropout censoring.}

\item{q, mu, sigma}{shape, location and scale parameters of an assumed generalized gamma distribution for the control arm.
A character string q="LLG" indiactes an assumed log-logistic survival distribution
\eqn{F_0(y;\xi,\zeta)=1/(1+(y/\xi)^{-\zeta})} for the control arm, where \eqn{\xi} = mu and \eqn{\zeta} = sigma.}

\item{rho}{the power in the weight of the Harrington-Fleming statistic.
\eqn{\rho=0} for the logrank test; \eqn{\rho=1} for the Wilcoxon test.}

\item{eta, theta}{parameters of the entry distribution with \eqn{\eta \ge -\theta/R} and \eqn{\eta >0}
(\eqn{\theta=0} for the uniform dropout censoring).}
}
\value{
\item{Info.fractions}{information fractions at times of all the interim analyses.}

\item{Event.prob}{the probability of events accumulated up to T.}

\item{Total.censor.prob}{the probability of censoring including the dropout and administrative censoring.}
}
\description{
A function calculates information fractions
with a generalized gamma survival distribution or a log-logistic survival distribution
for a given dropout censoring probability.
}
\examples{
General.tau(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.018),
         q=1, mu=0.367, sigma=1, rho=0, eta=1, theta=0)
General.tau(t=c(1,1.5,2,2.5), R=2, T=3, FUN.C=function(y) punif(y,0,7.211),
         q="LLG", mu=1, sigma=1.75, rho=0, eta=1, theta=0)
}
