% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frairand.R
\name{frairand}
\alias{frairand}
\title{Frailty with random effects in high dimensional data with MCMC}
\usage{
frairand(m, n, Ins, Del, Time, T.min, chn, iter, adapt, data)
}
\arguments{
\item{m}{Starting column number form where study variables to be selected.}

\item{n}{Ending column number till where study variables will get selected.}

\item{Ins}{Variable name of Institute information.}

\item{Del}{Variable name containing the event information.}

\item{Time}{Variable name containing the time information.}

\item{T.min}{Variable name containing the time of event information.}

\item{chn}{Numner of MCMC chains.}

\item{iter}{Define number of iterations as number.}

\item{adapt}{Define number of adaptations as number.}

\item{data}{High dimensional data having survival duration, event information and column of time for death cases.}
}
\value{
frairandout
omeg[i] are frailty effects.
}
\description{
Random effects frailty model
}
\details{
By given m and n, a total of 3 variables can be selected.
}
\examples{
\dontrun{
##
data(frailty)
frairand(m=5,n=7,Ins="institute",Del="del",Time="timevar",T.min="time.min",chn=2,iter=6,
 adapt=100,data=frailty)
##
}
}
\references{
Tawiah, R., Yau, K. K., McLachlan, G. J., Chambers, S. K., &
Ng, S. K. (2019). Multilevel model with random effects for clustered survival
data with multiple failure outcomes. \emph{Statistics in medicine}, \bold{38(6)}, 1036-1055.
}
\seealso{
fraidm fraidpm
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
