% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISL_swim_parse.R
\name{swim_parse_ISL}
\alias{swim_parse_ISL}
\alias{Swim_Parse_ISL}
\title{Formats swimming results from the International Swim League ('ISL') read with
\code{read_results} into a data frame}
\usage{
swim_parse_ISL(file, splits = FALSE, relay_swimmers = FALSE)

Swim_Parse_ISL(file, splits = FALSE, relay_swimmers = FALSE)
}
\arguments{
\item{file}{output from \code{read_results}}

\item{splits}{should splits be included, default is \code{FALSE}}

\item{relay_swimmers}{should relay swimmers be included as separate columns,
default is \code{FALSE}}
}
\value{
returns a data frame of ISL results
}
\description{
Takes the output of \code{read_results} and cleans it, yielding a data frame
of 'ISL' swimming results
}
\examples{
\dontrun{
swim_parse_ISL(
read_results(
"https://isl.global/wp-content/uploads/2019/11/isl_college_park_results_day_2.pdf"),
splits = TRUE,
relay_swimmers = TRUE)
 }
}
\seealso{
\code{swim_parse_ISL} must be run on the output of
  \code{\link{read_results}}
}
\author{
Greg Pilgrim \email{gpilgrim2670@gmail.com}
}
