% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.png.R
\name{taf.png}
\alias{taf.png}
\alias{tafpng}
\title{PNG Device}
\usage{
taf.png(filename, width = 1600, height = 1200, res = 200, ...)
}
\arguments{
\item{filename}{plot filename.}

\item{width}{image width.}

\item{height}{image height.}

\item{res}{resolution determining the text size, line width, plot symbol
size, etc.}

\item{\dots}{passed to \code{png}.}
}
\value{
No return value, called for side effects.
}
\description{
Open PNG graphics device to export a plot into the TAF \verb{report} folder.
}
\details{
The \code{filename} can be passed without the preceding
\code{"report/"}, and without the \code{".png"} filename extension.

Specifically, the function prepends \code{"report/"} to the filename if (1)
the filename does not contain a \code{"/"} separator, (2) the working
directory is not \verb{report}, and (3) the directory \verb{report} exists.
The function also appends \verb{".png"} to the filename if it does not
already have that filename extension.

This automatic filename manipulation can be bypassed by using the \code{png}
function directly.
}
\note{
A simple convenience function to shorten
\preformatted{png("report/plot.png", width=1600, height=1200, res=200)}
to
\preformatted{taf.png("plot")}

The \code{res} argument affects the text size, along with all other plot
elements. To change the text size of specific lattice plot elements, the
\code{zoom} function can be helpful.

For consistent image width and text size, it can be useful to keep the
default \code{width = 1600} but vary the \code{height} to adjust the desired
aspect ratio for each plot.
}
\examples{
\dontrun{
taf.png("myplot")
plot(1)
dev.off()

library(lattice)
taf.png("mytrellis")
xyplot(1~1)
dev.off()

library(ggplot2)
taf.png("myggplot")
qplot(1, 1)
dev.off()
}

}
\seealso{
\code{\link{png}} is the underlying function used to open a PNG graphics
device.

\code{\link{zoom}} changes text size in a lattice plot.

\code{\link{TAF-package}} gives an overview of the package.
}
