% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf2html.R
\name{taf2html}
\alias{taf2html}
\title{Convert TAF Table to HTML}
\usage{
taf2html(x, file = "", align = "", header = align,
  digits = getOption("digits"), center = "style=\\"text-align:center\\"",
  left = "style=\\"text-align:left\\"",
  right = "style=\\"text-align:right\\"", append = FALSE)
}
\arguments{
\item{x}{a data frame in TAF format.}

\item{file}{a filename, or special values \code{NULL} or \code{""}.}

\item{align}{a string (or a vector of strings) specifying alignment of data
cells.}

\item{header}{a string (or a vector strings) specifying alignment of header
cells.}

\item{digits}{significant digits for numeric columns.}

\item{center}{HTML attribute to indicate center alignment.}

\item{left}{HTML attribute to indicate left alignment.}

\item{right}{HTML attribute to indicate right alignment.}

\item{append}{whether to append to an existing file.}
}
\value{
\code{NULL}, or a vector of strings if \code{file = NULL}.
}
\description{
Convert a TAF table to HTML code and optionally write to a file.
}
\details{
The \code{align} argument can be a vector of strings to specify
column-specific alignment, for example \code{c("l","r","l","l")}. Only the
first letter (case-insensitive) is used, so \code{"left"} is equivalent to
\code{"L"}. An empty string (the default), or any string that does not begin
with \code{C}, \code{L}, or \code{R} indicates no specific alignment.

The \code{header} argument can be used to specify an alignment for the column
names that is different from the data values. The default is to use the same
alignment as the data values.

The \code{center}, \code{left}, and \code{right} arguments can be used to
specify the exact HTML attribute to render alignment, for users who are
familiar with cascading style sheets (CSS). For example, the long-winded
\code{style="text-align:center"} could be shortened to \code{class="L"} if a
corresponding class has been defined in CSS.

Instead of using \code{file} to pass a filename, it can have the special
value \code{file = NULL} to return the HTML code as a vector of strings or
\code{file = ""} (the default) to show the HTML in the console.
}
\note{
The resulting HTML conforms to the HTML5 standard and aims for compact
output, omitting optional closing tags and rendering each row of data as one
row of HTML code.
}
\examples{
taf2html(catage.taf)
taf2html(catage.taf, align=c("L","R","R","R","R"))

\dontrun{
taf2html(catage.taf, "catage.html")
taf2html(catage.taf, "catage.html", align=c("L","R","R","R","R"),
         append=TRUE)
}

}
\seealso{
\code{\link{write.taf}} writes a TAF table to a file.

\code{\link{TAF-package}} gives an overview of the package.
}
