% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_BIC_based_marginalLikelihood.R
\name{AIC_BIC_based_marginalLikelihood}
\alias{AIC_BIC_based_marginalLikelihood}
\title{Marginal likelihoods based on AIC or BIC}
\usage{
AIC_BIC_based_marginalLikelihood(fullModel = NULL, candidateModels = NULL,
  data, discreteSurv = TRUE, AIC = TRUE, package = "nnet", maxit = 150,
  numberCores = 1)
}
\arguments{
\item{fullModel}{formula of the model including all potential variables}

\item{candidateModels}{Instead of defining the full model we can also
specify the candidate models whose deviance statistic and d.o.f should be
computed}

\item{data}{the data}

\item{discreteSurv}{Boolean variable telling us whether a `simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{AIC}{if \code{TRUE}, AIC will be used, else we use BIC}

\item{package}{Which package should be used to fit the models; by default
the \code{nnet} package is used; we could also specify to use the package
'VGAM'}

\item{maxit}{Only needs to be specified with package \code{nnet}: maximal
number of iterations}

\item{numberCores}{How many cores should be used in parallel?}
}
\value{
a vector with the marginal likelihoods of all candidate models
}
\description{
This function computes the marginal likelihoods based on the AIC or on the
BIC, that will later be used to calculate the TBF.
}
\examples{
# data extraction:
data("VAP_data")

# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here the define time as a spline with 3 knots

# now we can compute the marginal likelihoods based on the AIC f.ex:
mL_AIC <-
AIC_BIC_based_marginalLikelihood(fullModel = FULL,
                                 data = VAP_data,
                                 discreteSurv = TRUE,
                                 AIC = TRUE)
}
\author{
Rachel Heyard
}
