% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_7.R
\name{get_profile_data}
\alias{get_profile_data}
\title{Retrieve TCGA Data corresponding to a Specific Genetic Profile of Interest}
\usage{
get_profile_data(
  case_id = "blca_tcga_all",
  gprofile_id = "blca_tcga_mutations",
  glist = c("TP53", "E2F1"),
  force_numeric = FALSE
)
}
\arguments{
\item{case_id}{String corresponding to the Identifier of a list of cases}

\item{gprofile_id}{String corresponding to the Identifier of a genetic Profile of interest}

\item{glist}{Character vector including one or more gene identifiers (ENTREZID or OFFICIAL_SYMOL)}

\item{force_numeric}{logical. Shall numeric data be coerced to numeric?}
}
\value{
data.frame with one row per gene and one column per case/sample
}
\description{
Retrieve Data corresponding to a Genetic Profile of interest from a study of interest.
This function is the workhorse of the TCGAretriever package and can be used to fetch data 
concerning several genes at once. For larger queries, the use of the fetch_all_tcgadata() 
function is mandatory.
}
\examples{
get_profile_data("blca_tcga_all", "blca_tcga_mutations", c("TP53", "E2F1"))

}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
