% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{save_single_image}
\alias{save_single_image}
\title{Save a single DICOM image file}
\usage{
save_single_image(series_instance_uid, sop_instance_uid, out_dir,
  out_file_name = NULL)
}
\arguments{
\item{series_instance_uid}{Series instance UID. To get a list of available series instance UIDs, call \code{\link{get_series_info}}.}

\item{sop_instance_uid}{SOP instance UID. To get a list of SOP instance UIDs for an image series, call \code{\link{get_sop_instance_uids}}.}

\item{out_dir}{Directory to write DICOM file to}

\item{out_file_name}{Name of DICOM file to write, with .dcm extension. If \code{out_file_name} is \code{NULL}, the original file name will be used.}
}
\value{
List containing elements:
\itemize{
  \item \code{out_file}: The output file that was written
  \item \code{response}: API response
}
}
\description{
Save a single DICOM image file
}
\examples{
\dontrun{
save_single_image(
     series_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.806935685832642465081499816867",
     sop_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.257663256941568276393774062283",
     out_dir = "~/Desktop")
save_single_image(
     series_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.806935685832642465081499816867",
     sop_instance_uid = "1.3.6.1.4.1.14519.5.2.1.5382.4002.257663256941568276393774062283",
     out_dir = "~/Desktop", out_file_name = "file.dcm")
}

}
\seealso{
\code{\link{get_series_info}},
\code{\link{get_sop_instance_uids}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
