% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_modality_names}
\alias{get_modality_names}
\title{Get modality names}
\usage{
get_modality_names(collection = NULL, body_part = NULL)
}
\arguments{
\item{collection}{TCIA collection name. If \code{collection} is \code{NULL},
modality names from all collections will be returned. To get a list of available collection
names, call \code{\link{get_collection_names}}.}

\item{body_part}{Body part name. If \code{body_part} is \code{NULL}, modality names
for all body parts will be returned. To get a list of available body part names, call
\code{\link{get_body_part_names}}.}
}
\value{
List containing elements:
\itemize{
  \item \code{modalities}: character vector of modality names
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get modality names
}
\examples{
\dontrun{
get_modality_names()
get_modality_names(collection = "TCGA-BRCA")
get_modality_names(body_part = "BREAST")
get_modality_names(collection = "TCGA-BRCA", body_part = "BREAST")
}

}
\seealso{
\code{\link{get_collection_names}},
\code{\link{get_body_part_names}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
