% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_new_studies_in_collection}
\alias{get_new_studies_in_collection}
\title{Get studies that have been added to a collection and optionally to a patient since a specified date}
\usage{
get_new_studies_in_collection(collection, date, patient_id = NULL)
}
\arguments{
\item{collection}{TCIA collection name. To get a list of available collection
names, call \code{\link{get_collection_names}}.}

\item{date}{Date in format "YYYY-MM-DD"}

\item{patient_id}{Patient ID. To get a list of available patient IDs, call \code{\link{get_patient_info}}.
If \code{patient_id} is \code{NULL}, relevant studies for all patients in the collection will be returned.}
}
\value{
List containing elements:
\itemize{
  \item \code{studies}: Data frame of collection, patient ID, and study instance UID
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get studies that have been added to a collection and optionally to a patient since a specified date
}
\examples{
\dontrun{
get_new_studies_in_collection("TCGA-BRCA", "2014-01-01")
get_new_studies_in_collection("TCGA-BRCA", "2014-01-01", "TCGA-OL-A66O")
}

}
\seealso{
\code{\link{get_collection_names}},
\code{\link{get_patient_info}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
