% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries_norm.R
\name{fsnorm}
\alias{fsnorm}
\title{\eqn{L_p} Norm of a Single Functional Summary}
\usage{
fsnorm(fsobj, p = 2)
}
\arguments{
\item{fsobj}{a functional summary object.}

\item{p}{an exponent in \eqn{[1,\infty)} (default: 2).}
}
\value{
an \eqn{L_p}-norm value.
}
\description{
Given a functional summary \eqn{\Lambda (t)}, compute the \eqn{p}-norm.
}
\examples{
\donttest{
## Generate Toy Data from 'gen2circles()'
dat = gen2circles(n=100)$data

## Compute PD, Landscapes, and Silhouettes
myPD  = diagRips(dat, maxdim=1)
myPL0 = diag2landscape(myPD, dimension=0)
myPL1 = diag2landscape(myPD, dimension=1)
myPS0 = diag2silhouette(myPD, dimension=0)
myPS1 = diag2silhouette(myPD, dimension=1)

## Compute 2-norm
fsnorm(myPL0, p=2)
fsnorm(myPL1, p=2)
fsnorm(myPS0, p=2)
fsnorm(myPS1, p=2)
}

}
\concept{summaries}
