% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_param.R
\name{calib_param}
\alias{calib_param}
\title{Automatic calibration of trip distribution laws' parameter}
\usage{
calib_param(av_surf, law = "NGravExp")
}
\arguments{
\item{av_surf}{a positive numeric value indicating the average surface
area of the locations (in square kilometer).}

\item{law}{a character indicating which law to use (see Details).}
}
\value{
An estimation of the optimal parameter value based on
the average surface area of the locations.
}
\description{
This function returns an estimation of the optimal parameter value based on
the average surface area of the locations (in square kilometer) according to
the law. This estimation has only been tested on commuting data
(in kilometer).
}
\details{
The estimation is based on the Figure 8 in
\insertCite{Lenormand2016;textual}{TDLM} for four types of laws. The
normalized gravity law with an exponential distance decay function
(\code{law = "NGravExp"}), the normalized gravity law with a power distance
decay function (\code{law = "NGravPow"}), the Schneider's intervening
opportunities law (\code{law = "Schneider"}) and the extended radiation law
(\code{law = "RadExt"}).
}
\examples{
data(county)

res <- extract_spatial_information(county, id = "ID")
av_surf <- mean(res$surface)

calib_param(av_surf = av_surf, law = "NGravExp")
calib_param(av_surf = av_surf, law = "NGravPow")
calib_param(av_surf = av_surf, law = "Schneider")
calib_param(av_surf = av_surf, law = "RadExt")

}
\references{
\insertRef{Lenormand2016}{TDLM}
}
\seealso{
\code{\link[=extract_opportunities]{extract_opportunities()}} \code{\link[=extract_spatial_information]{extract_spatial_information()}}
\code{\link[=check_format_names]{check_format_names()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
