% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_calibration.R
\name{chisq_calib}
\alias{chisq_calib}
\title{Chi Squared Calibration for Testing}
\usage{
chisq_calib(x, stat, df, ...)
}
\arguments{
\item{x}{Symmetric matrix observations. Either a \code{\link{fsm}} or a \code{\link{kfsm}}.}

\item{stat}{Function to compute the statistic.}

\item{df}{Degrees of freedom of the chi-squared distribution}

\item{...}{Passed to \code{stat}}
}
\value{
A list of
\itemize{
\item \code{pval} the \code{p}-value from the test
\item \code{t0} the statistic for the observations \code{x}
\item \code{df} The degrees of freedom of the chi-squared distribution
}

The returned object has class \code{TFORGE} (same as \code{\link[=boot_calib]{boot_calib()}}) for easy use of \code{print()}.
}
\description{
Similar to \code{\link[=boot_calib]{boot_calib()}}, but uses chi-squared calibration instead of bootstrapping.
}
