% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OI_multiplicity.R
\name{test_multiplicity_OI}
\alias{test_multiplicity_OI}
\title{Test of eigenvalue multiplicity assuming orthogonally invariant covariance}
\usage{
test_multiplicity_OI(x, mult, B = "chisq", refbasis = NULL)
}
\arguments{
\item{x}{A sample of matrices suitable for \code{\link[=as_fsm]{as_fsm()}}.}

\item{mult}{A vector specifying the eigenvalue multiplicity under the null hypothesis in descending order of eigenvalue size.}

\item{B}{Number of bootstrap samples. If \code{B = 'chisq'} then a chi-squared calibration is used instead.}

\item{refbasis}{Ignored (for compatibility with \code{\link[=test_multiplicity]{test_multiplicity()}}).}
}
\value{
A \code{TFORGE} object (see \code{\link[=boot_calib]{boot_calib()}} or \code{\link[=chisq_calib]{chisq_calib()}}) including p-value of the test (slot \code{pval}) and the statistic for \code{x} (slot \code{t0}).
}
\description{
Given a sample from a population of symmetric matrices with Gaussian-distributed elements and orthogonally-invariant covariance, corollary 4.3 by \insertCite{schwartzman2008in;textual}{TFORGE} provides a method to test the eigenvalue multiplicity of the mean matrix.
Orthogonally-invariant covariance is a strong assumption and may not be valid; consider using \code{\link[=test_multiplicity]{test_multiplicity()}} if you are unsure.
}
\details{
The orthogonally invariant covariance matrix is estimated by \code{\link[=estimate_OIcov]{estimate_OIcov()}}. The maximum-likelihood estimate of the population mean under the null hypothesis is computed according to \insertCite{@Theorem 4.2, @schwartzman2008in}{TFORGE}.
}
