% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper3D_max.R
\name{hyper_3D}
\alias{hyper_3D}
\alias{hyper3d_max}
\alias{hyper3d_min}
\title{2D or 3D rendering of max-plus or min-plus tropical hyperplane}
\usage{
hyper3d_max(D, di, mi, ma, plt = FALSE)

hyper3d_min(D, di, mi, ma, plt = FALSE)
}
\arguments{
\item{D}{point in the tropical projective torus representing the apex of the hyperplane}

\item{di}{scalar; indicates how far the hyperplane should extend}

\item{mi}{scalar; minimum value on axes of the plot}

\item{ma}{scalar; maximum value on axes of the plot}

\item{plt}{logical; if true produces a new plot otherwise overlays tropical hyperplane on existing plot}
}
\value{
2D or 3D rendering of max-plus or min-plus tropical hyperplane
}
\description{
This function renders a 2D or 3D max-plus or min-plus tropical hyperplane
}
\examples{
# 2D Example
D <-t(as.matrix(c(0,0,0)))
di<-4
mi<- -5
ma<-5
hyper3d_max(D,di,mi,ma,plt=TRUE)
hyper3d_min(D,di,mi,ma,plt=TRUE)

# 3D Example
D <-t(as.matrix(c(0,0,0,0)))
di<-4
mi<- -5
ma<-5
hyper3d_max(D,di,mi,ma,plt=TRUE)
hyper3d_min(D,di,mi,ma,plt=TRUE)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
