% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw.trop.dist.R
\name{pw.trop.dist}
\alias{pw.trop.dist}
\title{Constructs the dissimilarity matrix for a set of ultrametrics}
\usage{
pw.trop.dist(D1, D2)
}
\arguments{
\item{D1}{matrix of ultrametrics}

\item{D2}{matrix of ultrametrics}
}
\value{
matrix; dissimilarity matrix showing the tropical pairwise distance between each point
}
\description{
Constructs the dissimilarity matrix based on the tropical distance between points in a dataset
}
\examples{
\donttest{
T1<-Sim_Trees15
T2<-Sim_Trees25
D <- rbind(T1, T2[1,])
pw.trop.dist(D, D)
}
}
\references{
Weyenberg, G., Huggins, P., Schardl, C., Howe, D. K., & Yoshida, R. (2014). kdetrees: Nonparametric Estimation of Phylogenetic Tree Distributions. In Bioinformatics.

Yoshida, Ruriko, David Barnhill, Keiji Miura and Daniel Howe (2022). Tropical Density Estimation of Phylogenetic Trees.

\url{https://github.com/grady/kdetrees/blob/master/R/dist.diss.R}
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
