% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equ_ftest.R
\name{equ_ftest}
\alias{equ_ftest}
\title{Equivalence Test using an F-test}
\usage{
equ_ftest(Fstat, df1, df2, eqbound, MET = FALSE, alpha = 0.05)
}
\arguments{
\item{Fstat}{The F-statistic from the F-test.}

\item{df1}{Degrees of freedom for the numerator.}

\item{df2}{Degrees of freedom for the denominator.}

\item{eqbound}{Equivalence bound for the partial eta-squared.}

\item{MET}{logical indicator to perform a minimal effect test rather than equivalence test (default is FALSE).}

\item{alpha}{alpha used for the test (e.g., 0.05).}
}
\value{
Object of class '"htest"
\describe{
  \item{\code{"statistic"}}{The value of the F-statistic.}
  \item{\code{"parameter"}}{The degrees of freedom for the F-statistic.}
  \item{\code{"p.value"}}{The he p-value for the test.}
  \item{\code{"conf.int"}}{A confidence interval for the partial eta-squared statistic.}
  \item{\code{"estimate"}}{Estimate of partial eta-squared.}
  \item{\code{"null.value"}}{The specified for the equivalence test.}
  \item{\code{"method"}}{A string indicating the type of F-test.}
  \item{\code{"data.name"}}{A required string indicating that this was calculated from summary statistics.}
}
}
\description{
Performs equivalence test on the partial eta-squared (pes) value for using an F-test.
}
\section{References}{

Campbell, H., & Lakens, D. (2021). Can we disregard the whole model? Omnibus non‐inferiority testing for R2 in multi‐variable linear regression and in ANOVA. British Journal of Mathematical and Statistical Psychology, 74(1), 64-89. doi: 10.1111/bmsp.12201
}

