% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_smd.R
\name{compare_smd}
\alias{compare_smd}
\title{Comparing SMDs between independent studies}
\usage{
compare_smd(
  smd1,
  n1,
  se1 = NULL,
  smd2,
  n2,
  se2 = NULL,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  null = 0,
  TOST = FALSE
)
}
\arguments{
\item{smd1, smd2}{SMDs from study 1 & 2, respectively.}

\item{n1, n2}{sample size(s) from study 1 & 2, respectively (can be 1 number or vector of 2 numbers).}

\item{se1, se2}{User supplied standard errors (SEs). This will override the internal calculations.}

\item{paired}{a logical indicating whether the SMD is from a paired or independent samples design. If a one-sample design, then paired must be set to TRUE.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{null}{a number indicating the null hypothesis. For TOST, this would be equivalence bound.}

\item{TOST}{Defunct: use alternative argument. Logical indicator (default = FALSE) to perform two one-sided tests of equivalence (TOST).}
}
\value{
A list with class "htest" containing the following components:
\itemize{
\item "statistic": z-score.
\item "p.value": numeric scalar containing the p-value for the test under the null hypothesis.
\item "estimate": difference in SMD between studies.
\item "null.value": the specified hypothesized value for the null hypothesis.
\item "alternative": character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".
\item "method": Type of SMD.
\item "data.name": "Summary Statistics" to denote summary statistics were utilized to obtain results.
\item "smd": SMDs input for the function.
\item "sample_sizes": Sample sizes input for the function.
\item "call": the matched call.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function to compare standardized mean differences (SMDs) between studies. This function is intended to be used to compare the compatibility of original studies with replication studies (lower p-values indicating lower compatibility).
}
\details{
This function tests for differences between SMDs from independent studies (e.g., original vs replication).
}
\seealso{
Other compare studies: 
\code{\link{boot_compare_cor}()},
\code{\link{boot_compare_smd}()},
\code{\link{compare_cor}()}
}
\concept{compare studies}
