% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violin_plot.R
\name{violin_plot}
\alias{violin_plot}
\title{Violin plot support two levels and multiple groups with P value.}
\usage{
violin_plot(
  data,
  test_method = "wilcox.test",
  test_label = "p.format",
  group_level = "Three_Column",
  violin_orientation = "vertical",
  add_element = "boxplot",
  element_alpha = 0.5,
  my_shape = "plus_times",
  sci_fill_color = "Sci_AAAS",
  sci_fill_alpha = 0.5,
  sci_color_alpha = 1,
  legend_pos = "right",
  legend_dir = "vertical",
  ggTheme = "theme_light"
)
}
\arguments{
\item{data}{Dataframe: include Value, Level1, Level2 columns.}

\item{test_method}{Character: test methods of P value. Default: "wilcox.test", options: "wilcox.test", "t.test", "anova", "kruskal.test".}

\item{test_label}{Character: test label of P value. Default: "p.format", options: "p.signif", "p.format". c(0, 0.0001, 0.001, 0.01, 0.05, 1).}

\item{group_level}{Character: group levels. Default: "Three_Column", options: "Two_Column", "Three_Column".}

\item{violin_orientation}{Character: violin orientation. Default: "vertical", options: "vertical", "horizontal", "reverse".}

\item{add_element}{Character: add new plot. Default: "boxplot", options: "none", "dotplot", "jitter", "boxplot", "point", "mean", "mean_se", "mean_sd", "mean_ci", "mean_range", "median", "median_iqr", "median_hilow", "median_q1q3", "median_mad", "median_range".}

\item{element_alpha}{Numeric: element color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{my_shape}{Character: box scatter shape. Default: "plus_times", options: "border_square", "border_circle", "border_triangle", "plus", "times", "border_diamond", "border_triangle_down", "square_times", "plus_times", "diamond_plus", "circle_plus", "di_triangle", "square_plus", "circle_times","square_triangle", "fill_square", "fill_circle", "fill_triangle", "fill_diamond", "large_circle", "small_circle", "fill_border_circle", "fill_border_square", "fill_border_diamond", "fill_border_triangle".}

\item{sci_fill_color}{Character: ggsci color pallet. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_fill_alpha}{Numeric: ggsci fill color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{sci_color_alpha}{Numeric: ggsci border color alpha. Default: 1.00, min: 0.00, max: 1.00.}

\item{legend_pos}{Character: legend position. Default: "right", options: "none", "left", "right", "bottom", "top".}

\item{legend_dir}{Character: legend direction. Default: "vertical", options: "horizontal", "vertical".}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: violin plot support two levels and multiple groups with P value.
}
\description{
Violin plot support two levels and multiple groups with P value.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(box_data)

# 3. Default parameters
violin_plot(box_data)

# 4. Set test_label = "p.signif",
violin_plot(box_data, test_label = "p.signif")

# 5. Set violin_orientation = "horizontal"
violin_plot(box_data, violin_orientation = "horizontal")

# 6. Set group_level = "Two_Column"
violin_plot(box_data, group_level = "Two_Column")

# 7. Set add_element = "jitter"
violin_plot(box_data, add_element = "jitter")

}
\author{
benben-miao
}
