% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLTblder.R
\name{SVRModel}
\alias{SVRModel}
\title{Build support vector regression result}
\usage{
SVRModel(x, seqby = 80)
}
\arguments{
\item{x}{The calculation result returned from the function \code{\link[TPMplt:DMMprocess]{DMMprocess}}.}

\item{seqby}{A numeric value to specify the grid density. Default value is 80, namely the default mesh for
original plot uses 80*80.}
}
\value{
A data frame including continuous values for eta and xi, calculated based on the discrete values for
eta and xi returned from \code{\link[TPMplt:DMMprocess]{DMMprocess}}. The strain condition in current calculation
is also included.
}
\description{
Return a table with continuous values for eta and xi, based on prediction built by support vector
regression model (SVR). The kernel function in SVR is radial basis.
}
\examples{
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
PLTbd <- SVRModel(DMM)
PLTbd
}
\seealso{
\code{\link[TPMplt:DMMprocess]{DMMprocess}}
}
\keyword{PLTbuilder}
\keyword{SVRModel}
