% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{treatment_effect}
\alias{treatment_effect}
\title{treatment_effect}
\usage{
treatment_effect(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control parameters}
}
\value{
The difference in mean response across treatment arms.
}
\description{
Compute treatment effect as mean( treatment response ) - mean( control response )
}
\details{
This function will compute the treatment for the response. The
treatment effect is computed as the difference in means between the non-control
treatment arm and the control treatment arm. The user must provide the
treatment variable as well as the control value.
}
\examples{
N <- 100

df <- data.frame( continuous_response = numeric(N),
                  trt = integer(N) )

df$continuous_response <- runif( min = 0, max = 20, n = N )
df$trt <- sample( c(0,1), size = N, prob = c(0.4,0.6), replace = TRUE )

# Compute the treatment effect
treatment_effect( df, list( y_var = 'continuous_response', trt_control = 0 ) )

# Function return value should match this value
mean( df$continuous_response[df$trt == 1] ) - mean( df$continuous_response[df$trt == 0] )
}
\seealso{
\link{TSDT}, \link{mean_response}
}
