% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSplot_gen.R
\name{TSplot_gen}
\alias{TSplot_gen}
\title{'TSplot_gen'}
\usage{
TSplot_gen(origin_t, ARIMAmodel, XREG = NULL, NEWtitle = "Result",
  Ylab = "Value", Xlab = "Time", plot_labels = NULL,
  ts_original = "original time series",
  ts_forecast = "forecasted time series", title_size = 10,
  ts_list = "empty", ts_labels = NULL, ts_names = NULL,
  COLO = NULL)
}
\arguments{
\item{origin_t}{Number of periods of original time series data you wish to include in the plot write all if all
periods should be included}

\item{ARIMAmodel}{ARIMA model created by function \code{auto.arima()}}

\item{XREG}{if using ARIMAX model, put in the regularized X matrix}

\item{NEWtitle}{title for this plot}

\item{Ylab}{label of Y axis}

\item{Xlab}{label of X axis}

\item{plot_labels}{To include a specific labels for each time point of all training time series data and
predicted ARIMA(X) result. A vector should be applied to this parameter that has the same length of chosen
periods of training time series data (i.e. parameter \code{origin_t}) along with predicted time series periods.}

\item{ts_original}{label for original time series line}

\item{ts_forecast}{label for forecasted time series line}

\item{title_size}{size of the title}

\item{ts_list}{applying this function can help you draw more time lines into the original plot. A list should
be applied to this parameter which contains all extra time series data that you wish to draw on the original
plot. Each element on this list should be created by function \code{ts()}}

\item{ts_labels}{when drawing extra time lines with parameter \code{ts_list}. You could create specific labels
for each time points. A list with the same shape of list in \code{ts_list} should be applied. Each element in
this list should contain time labels corresponding with the list in \code{ts_list}}

\item{ts_names}{Creating labels for each extra time lines you draw. Labels will appear on the legend of the plot.}

\item{COLO}{Specifying colors for each new lines that is drawn.}
}
\value{
a plot result created by plot_ly() function
}
\description{
Plotly method working on time series analysis. This is a more general function that can work on any
fitted ARIMA(X) model with any time format. Also, a list of time series data can be applied into this function
so that new time lines can be directly drawn in the plot without referring to the result of ADDline function.
}
\details{
The function \code{TSplot_gen} is based on package \code{plotly}. It applies \code{plot_ly} function to create
interactive plot for time-series analysis result. It requires a fitted model by function \code{auto.arima}.
If you are fitting an ARIMA model with external regressors (i.e. \code{Xreg}), then you must put inside the
external regressors again.
}
\examples{
# Creating time labels
require(zoo)
require(forecast)
require(plotly)

tl1<-as.yearmon(time(modArima_train$x))[(length(modArima_train$x)-48+1):length(modArima_train$x)]
tl2<-as.yearmon(time(forecast(modArima_train,xreg = as.matrix(X_test))$mean))
tl<-as.character(c(tl1,tl2))
# Creating list and other information for new lines
TSlist<-list(MCSI_Data_monthAvg_ts_Y_test)
TSlabel<-list(as.character(as.yearmon(time(TSlist[[1]]))))
TSname<-c("Original result")
# Put them into related parameters
TSplot_gen(48,modArima_train,as.matrix(X_test),title_size = 8,ts_original = "Original time series",
        ts_forecast = "Predicted time series",plot_labels = tl, #labels of original plot
        ts_list = TSlist,ts_names = TSname,ts_labels = TSlabel,COLO = "black")

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
