% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nondata_adaptive_repr.R
\name{repr_dct}
\alias{repr_dct}
\title{DCT representation}
\usage{
repr_dct(x, coef = 10)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{coef}{the number of coefficients to extract from DCT}
}
\value{
the numeric vector of DCT coefficients
}
\description{
The \code{repr_dct} computes DCT (Discrete Cosine Transform) representation from a time series.
}
\details{
The length of the final time series representation is equal to set \code{coef} parameter.
}
\examples{
repr_dct(rnorm(50), coef = 4)

}
\seealso{
\code{\link[TSrepr]{repr_dft}, \link[TSrepr]{repr_dwt}, \link[dtt]{dtt}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
