% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBV.R
\name{OBV}
\alias{OBV}
\title{On Balance Volume (OBV)}
\usage{
OBV(price, volume)
}
\arguments{
\item{price}{Price series that is coercible to xts or matrix.}

\item{volume}{Volume series that is coercible to xts or matrix, that
corresponds to price object.}
}
\value{
A object of the same class as \code{price} and \code{volume} or a
vector (if \code{try.xts} fails) containing the OBV values.
}
\description{
On Balance Volume (OBV) is a measure of the money flowing into or out of a
security.  It is similar to Chaikin Accumulation / Distribution.
}
\details{
OBV is calculated by adding (subtracting) each day's volume to a running
cumulative total when the security's price closes higher (lower).
}
\note{
OBV is usually compared with the price chart of the underlying security
to look for divergences/confirmation.
}
\examples{

data(ttrc)
obv <- OBV(ttrc[,"Close"], ttrc[,"Volume"])

}
\references{
The following site(s) were used to code/document this
indicator:\cr \url{https://www.fmlabs.com/reference/OBV.htm}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=82}\cr
\url{https://www.linnsoft.com/techind/balance-open-interest}\cr
\url{https://www.stockcharts.com/school/doku.php?id=chart_school:technical_indicators:on_balance_volume_obv}\cr
}
\seealso{
See \code{\link{chaikinAD}}.
}
\author{
Joshua Ulrich
}
\keyword{ts}
