% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{routeDrawOptions}
\alias{routeDrawOptions}
\title{Options for Drawing Routes on the Map}
\usage{
routeDrawOptions(showMarkers = TRUE, showTransfers = TRUE,
  walkColour = "green", walkWeight = 5, walkDashArray = "1,10",
  carColour = "blue", carWeight = 5, carDashArray = NULL,
  bikeColour = "orange", bikeWeight = 5, bikeDashArray = NULL,
  transitColour = "red", transitWeight = 5, transitDashArray = NULL,
  transferColour = "blue", transferRadius = 10)
}
\arguments{
\item{showMarkers}{Whether to show the source/target markers.}

\item{showTransfers}{whether to highlight transfers between different modes of transport.}

\item{walkColour, bikeColour, carColour, transitColour}{Set the line colours.}

\item{walkWeight, bikeWeight, carWeight, transitWeight}{Set the line weights.}

\item{walkDashArray, bikeDashArray, carDashArray, transitDashArray}{Set the dash styles.}

\item{transferColour}{Set the colour of transfer markers.}

\item{transferRadius}{Set the size of transfer markers.}
}
\value{
A list of options governing how the routes are drawn on the map.
}
\description{
Function to return a list of the desired drawing options - you can set colours,
line weights and dash styles for each transport type, whether to show the source
and target markers, and whether to show transfers between different modes of transport.
}
\examples{
# show the list
routeDrawOptions()

}
