% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{fit.Weibull}
\alias{fit.Weibull}
\title{Weibull Distribution Parameter Estimation}
\usage{
fit.Weibull(time, status, sig = 0.05, init = NULL)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}

\item{init}{List containing an initial value for the shape parameter "a".}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{\alpha} and rate \eqn{\lambda}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
}
}
\description{
Estimates parameters for Weibull event times subject to non-informative
right censoring. The Weibull distribution is parameterized in terms
of the shape \eqn{\alpha} and rate \eqn{\lambda}:
\deqn{f(t) = \alpha\lambda^{\alpha}t^{\alpha-1}e^{-(\lambda t)^{\alpha}}, t>0}
}
\examples{
# Simulate
D = rWeibull(n=1e3,a=2,l=2);
# Estimate
M = fitParaSurv(time=D$time,status=D$status,dist="weibull");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
