% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{FitGamma}
\alias{FitGamma}
\title{Gamma Distribution Parameter Estimation}
\usage{
FitGamma(
  data,
  eps = 1e-06,
  init = list(),
  maxit = 10,
  report = FALSE,
  sig = 0.05,
  status_name = "status",
  tau = NULL,
  time_name = "time"
)
}
\arguments{
\item{data}{Data.frame.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{init}{List with initial values for the `shape` \eqn{\alpha} and
`rate` \eqn{\lambda}.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}

\item{sig}{Significance level, for CIs.}

\item{status_name}{Name of the status indicator, 1 if observed, 0 if censored.}

\item{tau}{Optional truncation times for calculating RMSTs.}

\item{time_name}{Name of column containing the time to event.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{\alpha} and rate \eqn{\lambda}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for gamma event times subject to non-informative
right censoring. The gamma distribution is parameterized in terms
of the shape \eqn{\alpha} and rate \eqn{\lambda}:
\deqn{f(t) = \frac{\lambda}{\Gamma(\alpha)}(\lambda t)^{\alpha-1}e^{-\lambda t}, t>0}
}
\examples{
# Generate Gamma data with 20\% censoring.
data <- GenData(n = 1e3, dist = "gamma", theta = c(2, 2), p = 0.2)

# Estimate parameters.
fit <- FitParaSurv(data, dist = "gamma")
}
