% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TriangleCentres}
\alias{TriangleCentres}
\title{Coordinates of triangle mid-points}
\usage{
TriangleCentres(resolution = 48L, direction = getOption("ternDirection", 1L))
}
\arguments{
\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}
}
\value{
\code{TriangleCentres()} returns a matrix with three named rows:
\itemize{
\item \code{x} \emph{x} coordinates of triangle midpoints;
\item \code{y} \emph{y} coordinates of triangle midpoints;
\item \code{triDown} \code{0} for upwards-pointing triangles, \code{1} for downwards-pointing.
}
}
\description{
Calculate \emph{x} and \emph{y} coordinates of the midpoints of triangles
tiled to cover a ternary plot.
}
\examples{
TernaryPlot(grid.lines = 4)
centres <- TriangleCentres(4)
text(centres["x", ], centres["y", ], ifelse(centres["triDown", ], "v", "^"))

}
\seealso{
Add triangles to a plot: \code{\link[=TernaryTiles]{TernaryTiles()}}

Other coordinate translation functions: 
\code{\link{ReflectedEquivalents}()},
\code{\link{TernaryCoords}()},
\code{\link{XYToTernary}()}

Other tiling functions: 
\code{\link{Polygon-Geometry}},
\code{\link{TriangleInHull}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{coordinate translation functions}
\concept{tiling functions}
