% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FdrMethods.R
\name{BHCor}
\alias{BHCor}
\title{Benjamini & Hochberg (1995)'s procedure for correlation testing.}
\usage{
BHCor(data, alpha = 0.05, stat_test = "gaussian", vect = FALSE)
}
\arguments{
\item{data}{matrix of observations}

\item{alpha}{level of multiple testing}

\item{stat_test}{\describe{
  \item{'empirical'}{\eqn{\sqrt{n}*abs(corr)}}
  \item{'fisher'}{   \eqn{\sqrt{n-3}*1/2*\log( (1+corr)/(1-corr) )}}
  \item{'student'}{  \eqn{\sqrt{n-2}*abs(corr)/\sqrt(1-corr^2)}}
  \item{'gaussian'}{ \eqn{\sqrt{n}*mean(Y)/sd(Y)} with \eqn{Y=(X_i-mean(X_i))(X_j-mean(X_j))}}
}}

\item{vect}{if TRUE returns a vector of TRUE/FALSE values, corresponding to vectorize(cor(data))
if FALSE, returns an array containing rows and columns of significative correlations}
}
\value{
Returns \itemize{\item{a vector of logicals, equal to TRUE if the corresponding element of the statistic vector is rejected, if \code{vect=TRUE},} \item{a vector containing indexes \eqn{\lbrace(i,j),\,i<j\rbrace} for which correlation between variables \eqn{i} and \eqn{j} is significative, if \code{vect=FALSE}.}}
}
\description{
Benjamini & Hochberg (1995)'s procedure on the correlation matrix entries (no theoretical proof of control).
}
\examples{
 
n <- 100
p <- 10
corr_theo <- diag(1,p)
data <- MASS::mvrnorm(n,rep(0,p),corr_theo)
alpha <- 0.05
res <- BHCor(data,alpha,stat_test='empirical')
}
\references{
Benjamini, Y., & Hochberg, Y. (1995). Controlling the false discovery rate: a practical and powerful approach to multiple testing. Journal of the royal statistical society. Series B (Methodological), 289-300.
}
\seealso{
ApplyFdrCor, BHBootCor
}
