% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\docType{methods}
\name{plotShadow}
\alias{plotShadow}
\alias{plotShadow,list-method}
\alias{plotShadow,output_Shadow-method}
\title{Draw a shadow test chart}
\usage{
plotShadow(object, constraints, examinee_id = 1,
  sort_by_difficulty = FALSE, file_pdf = NULL, ...)

\S4method{plotShadow}{list}(object, constraints, examinee_id = 1,
  sort_by_difficulty = FALSE, file_pdf = NULL, ...)

\S4method{plotShadow}{output_Shadow}(object, constraints,
  examinee_id = 1, sort_by_difficulty = FALSE, file_pdf = NULL, ...)
}
\arguments{
\item{object}{An output from \code{\link{Shadow}} function.}

\item{constraints}{The constraint object used in obtaining the output.}

\item{examinee_id}{Numeric ID of the examinee to draw the plot.}

\item{sort_by_difficulty}{Sort the items by difficulty.}

\item{file_pdf}{If supplied a filename, save as a PDF file.}

\item{...}{Additional options to be passed on to \code{pdf()}.}
}
\description{
Draw a chart of shadow tests constructed for each simulee. The index of a column represents the position of item administration process, and each column represents the item pool.
}
\examples{
object <- itempool_science
config <- createShadowTestConfig()
true_theta <- rnorm(1)
solution <- Shadow(itempool_science, config, true_theta, constraints_science)
plotShadow(solution, constraints_science, 1)

}
