% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeMolecularProfiles.R
\name{summarizeMolecularProfiles}
\alias{summarizeMolecularProfiles}
\title{Takes molecular data from a ToxicoSet, and summarises them
into one entry per drug and experimental condition.}
\usage{
summarizeMolecularProfiles(tSet, mDataType, cell.lines, drugs, features,
  duration, dose = c("Control", "Low", "Middle", "High"),
  summary.stat = c("mean", "median", "first", "last"),
  fill.missing = TRUE, summarize = TRUE, verbose = TRUE)
}
\arguments{
\item{tSet}{\code{ToxicoSet} The ToxicoSet to summarize}

\item{mDataType}{\code{character} which one of the molecular data types
to use in the analysis, out of all the molecular data types available for the tSet
for example: rna}

\item{cell.lines}{\code{character} The cell lines to be summarized.
If any cell.line has no data, missing values will be created}

\item{drugs}{\code{character} The drugs to be summarized}

\item{features}{\code{character} A vector of the feature names to include in the summary}

\item{duration}{\code{character} A vector of durations to summarize across}

\item{dose}{\code{character} The dose level to summarize replicates across}

\item{summary.stat}{\code{character} which summary method to use if there are repeated
cell.lines? Choices are "mean", "median", "first", or "last"}

\item{fill.missing}{\code{boolean} should the missing cell lines not in the
molecular data object be filled in with missing values?}

\item{summarize}{A flag which when set to FALSE (defaults to TRUE) disables summarizing and
returns the data unchanged as a ExpressionSet}

\item{verbose}{\code{boolean} should messages be printed}
}
\value{
\code{SummarizedExperiment} A SummarizedExperiment object with the molecular data summarized
  per cell line.
}
\description{
Given a ToxicoSet with molecular data, this function will summarize
the data into one profile per experimental condition (duration, dose level)
using the chosen summary.stat and return a SummarizedExperiment object, with
one Assay corresponding to a requested drug.
}
\examples{
data(TGGATESsmall)
summMP <- ToxicoGx::summarizeMolecularProfiles(
  tSet = TGGATESsmall, mDataType = "rna",
  cell.lines=cellNames(TGGATESsmall), drugs = head(drugNames(TGGATESsmall)),
  features = fNames(TGGATESsmall,"rna"), duration = "8",
  dose = c("Control", "High"), summary.stat = "median",
  fill.missing = TRUE, verbose=TRUE
  )

#subset into expression matrix for a requested drug
assays <- SummarizedExperiment::assays(summMP)[[drugNames(TGGATESsmall)[1]]]
#summarization of phenoData for requested experiments
phenoData <- SummarizedExperiment::colData(summMP)
#summarization of phenoData for requested experiments
featureData <- SummarizedExperiment::rowData(summMP) #featureData for requested experiments

}
