% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_formats.R
\name{apply_formats}
\alias{apply_formats}
\title{Apply Format Strings outside of a Tplyr table}
\usage{
apply_formats(format_string, ..., empty = c(.overall = ""))
}
\arguments{
\item{format_string}{The desired display format. X's indicate digits. On the
left, the number of x's indicates the integer length. On the right, the
number of x's controls decimal precision and rounding. Variables are
inferred by any separation of the 'x' values other than a decimal.}

\item{...}{The variables to be formatted using the format specified in
\code{format_string}. These must be numeric variables.}

\item{empty}{The string to display when the numeric data is not available.
Use a single element character vector, with the element named '.overall' to
instead replace the whole string.}
}
\value{
Character vector of formatted values
}
\description{
The \code{f_str} object in Tplyr is used to drive formatting of the outputs
strings within a Tplyr table. This function allows a user to use the same
interface to apply formatted string on any data frame within a
\code{dplyr::mutate()} context.
}
\details{
Note that auto-precision is not currently supported within \code{apply_formats()}
}
\examples{

library(dplyr)

mtcars \%>\%
  head() \%>\%
  mutate(
    fmt_example = apply_formats('xxx (xx.x)', hp, wt)
  )
}
