% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateOutbreak.R
\name{simulateOutbreak}
\alias{simulateOutbreak}
\title{Simulate an outbreak}
\usage{
simulateOutbreak(off.r = 1, off.p = 0.5, neg = 0.25, nSampled = NA,
  pi = 0.5, w.shape = 2, w.scale = 1, ws.shape = NA,
  ws.scale = NA, w.mean = NA, w.std = NA, ws.mean = NA,
  ws.std = NA, dateStartOutbreak = 2000, dateT = Inf)
}
\arguments{
\item{off.r}{First parameter of the negative binomial distribution for offspring number}

\item{off.p}{Second parameter of the negative binomial distribution for offspring number}

\item{neg}{the within-host effective population size (Ne) timesgeneration duration (g)}

\item{nSampled}{number of sampled infected individuals, or NA for any}

\item{pi}{probability of sampling an infected individual}

\item{w.shape}{Shape parameter of the Gamma probability density function representing the generation time}

\item{w.scale}{Scale parameter of the Gamma probability density function representing the generation time}

\item{ws.shape}{Shape parameter of the Gamma probability density function representing the sampling time}

\item{ws.scale}{Scale parameter of the Gamma probability density function representing the sampling time}

\item{w.mean}{Mean of the Gamma distribution representing the generation time}

\item{w.std}{Std of the Gamma distribution representing the generation time}

\item{ws.mean}{Mean of the Gamma distribution representing the sampling time}

\item{ws.std}{Std of the Gamma distribution representing the sampling time}

\item{dateStartOutbreak}{Date when index case becomes infected}

\item{dateT}{Date when process stops (this can be Inf for fully simulated outbreaks)}
}
\value{
Combined phylogenetic and transmission tree
}
\description{
Simulate an outbreak
}
\examples{
simulateOutbreak()
simulateOutbreak(off.r=2,dateStartOutbreak=2010,dateT=2015)
}
