% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbc.ad.R
\name{dbc.ad}
\alias{dbc.ad}
\title{Analise de experimento  conduzido no delineamento em blocos casualizados com
testemunhas adicionais}
\usage{
dbc.ad(Dados,alfa=0.05,quali=TRUE,verbose=TRUE,plot=2)
}
\arguments{
\item{Dados}{Matriz contendo na primeira coluna a identificacao dos
testemunhas (tratamentos comuns deve ter valor zero ou NA). A segunda coluna
deve ter a identificacao de todos os tratamentos.  A terceira coluna a
identificacao dos blocos. A quarta coluna a variavel resposta.}

\item{alfa}{valor indicando o nivel de significancia deve ser
obrigatoriamente "0.001", "0.01", "0.05" ou "0.10" (default = 0.05).}

\item{quali}{Valor logico (TRUE/FALSE). TRUE indica que o tratamento e
qualitativo, realizando-se o teste de medias. FALSE indica que o fator e
quantitativo, sendo feita a analise de regressao.}

\item{verbose}{Valor logico (TRUE/FALSE). TRUE apresenta os resultados da analise.}

\item{plot}{Valor numerico indicando o grafico desejado para analise dos residuos:
\itemize{
 \item 1: Residuals vs Fitted
\item 2:  QQ-plot
 \item 3:  Scale-Location
  \item 4:  Cook's distance
   \item 5: Histogram
   }}
}
\value{
Retorna a comparacao multipla de medias obtida por varios testes.
}
\description{
Esta funcao retorna a comparacao multipla de medias (obtidas
 pelos testes t, t com protecao de Bonferroni, Duncan, Dunnet, SNK, Tukey e
 Scott-Knott) se os tratamentos for qualitativos. Ou a analise de regressao
 se os tratamentos forem quantitativos. Para comparar a testemunha adicional
 com os demais e utilizado o teste Dunnet. Esta funcao considera o
 delineamento em blocos casualizados. "This function returns the multiple
 comparison tests (t, t tests with Bonferroni protection, Duncan, Dunnet,
 SNK, Tukey and Scott-Knott ) if the treatments are qualitative. Or
 regression analysis if treatments are quantitative. To compare the
 additional control with the others treatments, the Dunnet test is used. This
 function considers the randomized block design."
}
\examples{
 ######
 #Exemplo de um experimento em DBC com tratamentos qualitativos e uma
 #testemunha adicional
 data(Dados1)
 dbc.ad(Dados = Dados1,alfa = 0.05,quali =TRUE)
 #Exemplo de um experimento em DBC com tratamentos quantitativos e tres
 #testemunhas adicionais
data(Dados2)
dbc.ad(Dados = Dados2,alfa = 0.05,quali =FALSE)
}
\references{
<https://www.youtube.com/playlist?list=PLvth1ZcREyK4wSzwg-IxvrzaNzSLLrXEB>

 BANZATTO, D. A.; KRONKA, S. N. Experimentacao Agricola. 4 ed.
 Jaboticabal: Funep. 2006. 237 p.

 GOMES, F. P. Curso de Estatistica Experimental. 10a ed. Piracicaba:
 ESALQ/USP. 1982. 430.
}
\author{
Alcinei Mistico Azevedo, \email{alcineimistico@hotmail.com}
}
