% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataTrait.R
\name{genTraitMPT}
\alias{genTraitMPT}
\title{Generate Data for Trait MPT Models}
\usage{
genTraitMPT(N, numItems, eqnfile, restrictions, mean = NULL, sigma = NULL,
  rho = NULL, warning = TRUE)
}
\arguments{
\item{N}{number of participants}

\item{numItems}{number of responses per tree (a named vector with tree labels)}

\item{eqnfile}{The (full path to the) file that specifies the MPT model (standard .eqn syntax). Note that category labels must start with a letter (different to multiTree) and match the column names of \code{data}. Alternatively, the EQN-equations can be provided within R as a character value (cf. \code{\link{readEQN}})}

\item{restrictions}{Specifies which parameters should be (a) constant (e.g., \code{"a=b=.5"}) or (b) constrained to be identical (e.g., \code{"Do=Dn"}) or (c) treated as fixed effects (i.e., identical for all participants; \code{"a=b=FE"}). Either given as the path to a text file with restrictions per row or as a list of restrictions, e.g., \code{list("D1=D2","g=0.5")}}

\item{mean}{Named vector of true group means of individual MPT parameters (probabilities in the interval [0,1]). If the vector is not named, the internal order of parameters is used (can be obtained using \code{\link{readEQN}}).}

\item{sigma}{(named) vector of group standard deviations of latent (!) individual MPT parameters. Default is zero (no person heterogeneity).}

\item{rho}{(named) correlation matrix for latent (!) individual MPT parameters. Must be symmetric and positive definite (e.g., no correlations of 1 or -1 allowed). Default: a diagonal matrix (i.e., zero correlations)

Data are generated independently from the JAGS model files used for fitting the Trait-MPT model. If data for an equality-constrained version of the MPT model are required, the restrictions need to be hard-coded into the EQN-model file. Note that equal means still result in nonidentical MPT parameters on the individual level!}

\item{warning}{whether to show warning in case the naming of arguments does not match}
}
\value{
a list including the generated frequencies (\code{data}) and the true, underlying parameters (\code{parameters})
}
\description{
Generating a data file with known parameter structure using the Trait-MPT. Useful for simulations and robustness checks.
}
\examples{
# Example: Standard Two-High-Threshold Model (2HTM)
EQNfile <- system.file("MPTmodels/2htm.eqn", package="TreeBUGS")
rho <- matrix(c(1,.8,.2,
                .8,1,.1,
                .2,.1,1), nrow=3)
colnames(rho) <- rownames(rho) <- c("Do","Dn","g")
genDat <- genTraitMPT(N = 100,
                      numItems = c(Target=250, Lure=250),
                      eqnfile = EQNfile,
                      mean = c(Do=.7, Dn=.7, g=.5),
                      sigma =   c(Do=.3, Dn=.3, g=.15),
                      rho = rho)
head(genDat$data, 3)
plotFreq(genDat$data, eqn=EQNfile)
}
\references{
Klauer, K. C. (2010). Hierarchical multinomial processing tree models: A latent-trait approach. Psychometrika, 75, 70-98.
}
\seealso{
\code{\link{genMPT}}
}

