% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\encoding{UTF-8}
\name{MeilaVariationOfInformation}
\alias{MeilaVariationOfInformation}
\alias{MeilaMutualInformation}
\title{Use variation of clustering information to compare pairs of splits}
\usage{
MeilaVariationOfInformation(split1, split2)

MeilaMutualInformation(split1, split2)
}
\arguments{
\item{split1, split2}{Logical vectors listing leaves in a consistent order,
identifying each leaf as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the split in question.}
}
\value{
\code{MeilaVariationOfInformation()} returns the variation of (clustering)
information, measured in bits.

\code{MeilaMutualInformation()} returns the mutual information,
measured in bits.
}
\description{
Compare a pair of splits viewed as clusterings of taxa, using the variation
of clustering information proposed by Meilă (2007).
}
\details{
This is equivalent to the mutual clustering information (Vinh \emph{et al.} 2010).
For the total information content, multiply the VoI by the number of leaves.
}
\examples{
# Maximum variation = information content of each split separately
A <- TRUE
B <- FALSE
MeilaVariationOfInformation(c(A, A, A, B, B, B), c(A, A, A, A, A, A))
Entropy(c(3, 3) / 6) + Entropy(c(0, 6) / 6)

# Minimum variation = 0
MeilaVariationOfInformation(c(A, A, A, B, B, B), c(A, A, A, B, B, B))

# Not always possible for two evenly-sized splits to reach maximum
# variation of information
Entropy(c(3, 3) / 6) * 2  # = 2
MeilaVariationOfInformation(c(A, A, A,B ,B, B), c(A, B, A, B, A, B)) # < 2

# Phylogenetically uninformative groupings contain spliting information
Entropy(c(1, 5) / 6)
MeilaVariationOfInformation(c(B, A, A, A, A, A), c(A, A, A, A, A, B))
}
\references{
\insertRef{Meila2007}{TreeDist}

\insertRef{Vinh2010}{TreeDist}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
