% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_nni.R
\name{NNIDist}
\alias{NNIDist}
\title{Approximate Nearest Neighbour Interchange distance}
\usage{
NNIDist(tree1, tree2 = tree1)
}
\arguments{
\item{tree1, tree2}{Single trees of class \code{phylo} to undergo comparison.}
}
\value{
\code{NNIDist()} returns, for each pair of trees, a named vector
containing three integers:
\itemize{
\item \code{lower} is a lower bound on the NNI distance, and corresponds
to the RF distance between the trees.
\item \code{tight_upper} is an upper bound on the distance, based on calculated
maximum diameters for trees with < 13 leaves.  \emph{NA} is returned if trees are
too different to employ this approach.
\item \code{loose_upper} is a looser upper bound on the distance, using \emph{n} log \emph{n} +
O(\emph{n}).
}
}
\description{
Use the approach of Li \emph{et al.} (1996) to approximate the Nearest Neighbour
Interchange distance (Robinson, 1971) between phylogenetic trees.
}
\details{
In brief, this approximation algorithm works by identifying edges in one
tree that do not match edges in the second.  Each of these edges must
undergo at least one NNI operation in order to reconcile the trees.
Edges that match in both trees need never undergo an NNI operation, and
divide each tree into smaller regions.  By 'cutting' matched edges into two,
a tree can be divided into a number of regions that solely comprise unmatched
edges.

These regions can be viewed as separate trees that need to be reconciled.
One way to reconcile these trees is to conduct a series of NNI operations
that reduce a tree to a pectinate (caterpillar) tree, then to conduct an
analogue of the mergesort algorithm.  This takes at most \emph{n} log \emph{n} + O(\emph{n})
NNI operations, and provides a loose upper bound on the NNI score.
The maximum number of moves for an \emph{n}-leaf tree can be calculated
exactly for small trees; this provides a tighter upper bound, but is
unavailable for \emph{n} > 12.

\tabular{rccccccccccccc}{
Leaves:   \tab 1 \tab 2 \tab 3 \tab 4 \tab 5 \tab 6 \tab 7 \tab 8 \tab 9
\tab 10 \tab 11 \tab 12 \tab 13 \cr
Diameter: \tab 0 \tab 0 \tab 0 \tab 1 \tab 3 \tab 5 \tab 7 \tab 10 \tab 12
\tab 15 \tab 18 \tab 21 \tab ? \cr
}
}
\examples{
library('TreeTools', quietly = TRUE, warn.conflicts = FALSE)

NNIDist(BalancedTree(7), PectinateTree(7))

NNIDist(BalancedTree(7), as.phylo(0:2, 7))
NNIDist(as.phylo(0:2, 7), PectinateTree(7))

NNIDist(list(bal = BalancedTree(7), pec = PectinateTree(7)),
        as.phylo(0:2, 7))

CompareAll(as.phylo(30:33, 8), NNIDist)
}
\references{
\insertRef{Li1996}{TreeDist}

\insertRef{Robinson1971}{TreeDist}
}
\seealso{
Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{KendallColijn}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
