% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trustworthiness.R
\name{ProjectionQuality}
\alias{ProjectionQuality}
\title{Quality of projected distances}
\usage{
ProjectionQuality(original, projected, neighbours = 10L)
}
\arguments{
\item{original, projected}{Square matrix or \code{dist} object containing
original / projected pairwise distances.}

\item{neighbours}{Number of nearest neighbours to use in calculation.}
}
\value{
\code{ProjectionQuality()} returns a named vector of length four,
containing the entries: \code{Trustworthiness}, \code{Continuity}, \code{TxC}
(the product of these values), and \code{sqrtTxC} (its square root).
}
\description{
\code{ProjectionQuality()} calculates the trustworthiness and continuity
of projected distances (Venna & Kaski 2001; Kaski \emph{et al.} 2003).
Trustworthiness measures, on a scale from 0--1,
the degree to which points that are nearby in a projection are truly close
neighbours; continuity, the extent to which points that are truly nearby
retain their close spatial proximity in a projection.
}
\examples{
library('TreeTools', quietly = TRUE, warn.conflict = FALSE)
trees <- as.phylo(0:10, nTip = 8)
distances <- ClusteringInfoDistance(trees)
projection <- cmdscale(distances)
ProjectionQuality(distances, dist(projection), 4)
}
\references{
\insertRef{Venna2001}{TreeDist}

\insertRef{Kaski2003}{TreeDist}
}
\seealso{
Other tree space functions: 
\code{\link{Project}()},
\code{\link{SpectralClustering}()},
\code{\link{median.multiPhylo}()}
}
\author{
Wrapper for functions from Charlotte Soneson's \pkg{dreval},
https://github.com/csoneson/dreval/blob/master/R/trustworthiness.R
}
\concept{tree space functions}
